function [mask_roiR] = rotate_using_tform(pc_roi,mask_roi,tform)
% to rotate roi using tform  and return reshaped z-coordinate
%% input
% pc_roi: point cloud of the region of interest
% mask_roi : binary mask of the region of interest
% tform : matrix for translation and rotation of the region of interest

%% output
% mask_roiR : registered mask roi using matrix tform

pc_mask_roiR= pctransform(pc_roi,tform);
mask_roi_reshaped =reshape(pc_mask_roiR.Location(:,3),[size(mask_roi,1) size(mask_roi,2)]);
mask_roi_uint8=convertMat2gray(mask_roi_reshaped);
mask_roiR=uint8(255.*mask_roi_uint8);

end

